#include <bits/stdc++.h>

using namespace std;

const int N = 8e4+10;
int n, Q;
int p[N];
vector<int> g[N];

void pst() {
    while(Q--) {
    	int t;
    	cin >> t;
    	if(t == 1) {
    		int a, b;
    		cin >> a >> b;
    		swap(p[a], p[b]);
    	} else {
    		int l, r, x;
    		cin >> l >> r >> x;
    		bool mark[n+1];
    		int dist[n+1];
    		for(int i = 1; i <= n; i++) {
    			mark[i] = false;
    			dist[i] = 1e9;
    		}
    		dist[x] = 0;
    		queue<int> q;
    		q.push(x);
    		while(!q.empty()) {
    			int u = q.front();
    			q.pop();
    			mark[u] = true;
    			for(int v : g[u]) {
    				if(mark[v]) continue;
    				q.push(v);
    				dist[v] = min(dist[v], dist[u] + 1);
    			}
    		}
    		int mx = 0;
    		for(int i = l; i <= r; i++) mx = max(mx, dist[p[i]]);
    		cout << mx << "\n";
    	}
    }
}

bool mark[N];
int dist[N];
pair<int, int> st[4*N];

void build(int index, int l, int r) {
	if(l > r) return;
	if(l == r) {
		st[index].first = st[index].second = dist[p[l]];
		return;
	}
	int mid = (l + r) >> 1;
	build(2*index, l, mid);
	build(2*index+1, mid+1, r);
	st[index].first = max(st[2*index].first, st[2*index+1].first);
	st[index].second = min(st[2*index].second, st[2*index+1].second);
}

void update(int index, int l, int r, int x, int val) {
	if(l > r || r < x || x < l) return;
	if(l == r) {
		st[index].first = st[index].second = val;
		return;
	}
	int mid = (l + r) >> 1;
	update(2*index, l, mid, x, val);
	update(2*index+1, mid+1, r, x, val);
	st[index].first = max(st[2*index].first, st[2*index+1].first);
	st[index].second = min(st[2*index].second, st[2*index+1].second);
}

pair<int, int> get(int index, int l, int r, int L, int R) {
	if(l > r || r < L || R < l) return {-1, 1e9};
	if(L <= l && r <= R) return st[index];
	int mid = (l + r) >> 1;
	pair<int, int> gt1 = get(2*index, l, mid, L, R);
	pair<int, int> gt2 = get(2*index+1, mid+1, r, L, R);
	return {max(gt1.first, gt2.first), min(gt1.second, gt2.second)};
}

void dfs1(int root) {
	if(mark[root]) return;
	mark[root] = true;
	for(int u : g[root]) {
		if(mark[u]) continue;
		dist[u] = dist[root] + 1;
		dfs1(u);
	}
}

void dst() {
	int root;
	for(int i = 1; i <= n; i++) if(g[i].size() == 1) {
		root = i;
		break;
	}
	dfs1(root);
	for(int i = 0; i <= N; i++) {
		st[i].first = -1;
		st[i].second = 1e9;
	}
	build(1, 1, n);
	while(Q--) {
		int t;
		cin >> t;
		if(t == 1) {
			int a, b;
			cin >> a >> b;
			update(1, 1, n, a, dist[p[b]]);
			update(1, 1, n, b, dist[p[a]]);
			swap(p[a], p[b]);
		} else {
			int l, r, x;
			cin >> l >> r >> x;
			pair<int, int> gt = get(1, 1, n, l, r);
			cout << max(abs(gt.first - dist[x]), abs(gt.second - dist[x])) << "\n";
		}
	}
}

void dfs2(int root) {
	if(mark[root]) return;
	mark[root] = true;
	for(int u : g[root]) {
		if(mark[u]) continue;
		dist[u] = dist[root] + 1;
		dfs2(u);
	}
}

void tst() {
	dfs2(1);
	for(int i = 0; i <= N; i++) {
		st[i].first = -1;
		st[i].second = 1e9;
	}
	build(1, 1, n);
	while(Q--) {
		int t;
		cin >> t;
		if(t == 1) {
			int a, b;
			cin >> a >> b;
			update(1, 1, n, a, dist[p[b]]);
			update(1, 1, n, b, dist[p[a]]);
			swap(p[a], p[b]);
		} else {
			int l, r, x;
			cin >> l >> r >> x;
			cout << get(1, 1, n, l, r).first << "\n";
		}
	}
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    for(int i = 1; i <= n; i++) cin >> p[i];
    for(int i = 1; i < n; i++) {
    	int u, v;
    	cin >> u >> v;
    	g[u].push_back(v);
    	g[v].push_back(u);
    }
    cin >> Q;
    bool DST = true;
    for(int i = 1; i <= n; i++) if(g[i].size() > 2) {
    	DST = false;
    	break;
    }
    if(n <= 4000 && Q <= 4000) pst();
    else if(DST) dst();
    else tst();
    return 0;
}